/* <nagf02.h>
 *
 * Copyright 1996 Numerical Algorithms Group
 *
 * Include file for NAG C Library f02 Chapter
 *
 * Mark 4, revised, 1996.
 * Mark 5 revised. IER-2150 (Feb 1998).
 * Mark 6 revised. IER-3033 (July 2000).
 */
#ifndef NAGF02
#define NAGF02

/// ML 9/22/2004 COMPILING_ONAG8HEADERS_IN_OC
#ifndef _MSC_VER	   //VC
	// This must be put into every header since it does not appear to be
	// inheritable from parent header to child (#include-ded) header:
	#pragma dll(ONAG8)
#endif // !_MSC_VER	   //VC
/// end COMPILING_ONAG8HEADERS_IN_OC

#ifdef __cplusplus
extern "C"
{
#endif
  /* begin proto */
  extern NAG_DLL_EXPIMP void NAG_CALL f02aac(Integer n, double *a, Integer tda, double *r, 
                                             NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02abc(Integer n, double *a, Integer tda, double *r, double *v, 
                                             Integer tdv, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02adc(Integer n, double *a, Integer tda, double *b, Integer tdb, 
                                             double *r, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02aec(Integer n, double *a, Integer tda, double *b, Integer tdb,
                                             double *r, double *v, Integer tdv, NagError *fail);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02afc(Integer n, double *a, Integer tda, Complex *r,
                                             Integer *iter, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02afc(Integer n, double *a, Integer tda, complex *r,
                                             Integer *iter, NagError *fail);
  extern void f02aff_f(double a[], Integer ia, Integer n, double rr[],
                       double ri[], Integer intger[], Integer *lfail);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02agc(Integer n, double a[],  Integer tda, Complex r[],
                                             Complex v[],  Integer tdv, Integer iter[], NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02agc(Integer n, double a[],  Integer tda, complex r[],
                                             complex v[],  Integer tdv, Integer iter[], NagError *fail);
  extern void f02amc(Integer n, double eps, double *d, double *e, double *z, 
                     Integer tdz, NagError *fail);
  //Cheney change Complex to complex 2006-6-6
  /*extern void f02apc(Integer nn, double acc, double *h, Integer tdh, 
                     Complex *eigvals, Integer *icnt, NagError *fail);*/
  extern void f02apc(Integer nn, double acc, double *h, Integer tdh, 
                     complex *eigvals, Integer *icnt, NagError *fail);
  extern void f02apz_f(Integer nn, double acc, double h[], Integer ih,
                       double wr[], double wi[], Integer icnt[], Integer *lfail);
   //Cheney change Complex to complex 2006-6-6
  /*extern void f02aqc(Integer n, Integer low, Integer upp, 
                     double machep, double *h, Integer tdh, double *vecs, 
                     Integer tdvecs, Complex *eigvals, Integer *cnt, NagError *fail);*/
  extern void f02aqc(Integer n, Integer low, Integer upp, 
                     double machep, double *h, Integer tdh, double *vecs, 
                     Integer tdvecs, complex *eigvals, Integer *cnt, NagError *fail);
  extern void f02avc(Integer n, double acheps, double *d, double *e, NagError *fail);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02awc(Integer n, Complex a[], Integer tda, double r[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02axc(Integer n, Complex a[], Integer tda, double r[],
                                             Complex v[], Integer tdv, NagError *fail);
  extern void f02ayc(Integer n, double eps, double d[], double e[],
                     Complex v[], Integer tdv, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02bjc(Integer n, double a[], Integer tda, double b[],
                                             Integer tdb, double tol, Complex alfa[],
                                             double beta[], Boolean wantv,
                                             double v[], Integer tdv, Integer iter[], NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02awc(Integer n, complex a[], Integer tda, double r[], NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02axc(Integer n, complex a[], Integer tda, double r[],
                                             complex v[], Integer tdv, NagError *fail);
  extern void f02ayc(Integer n, double eps, double d[], double e[],
                     complex v[], Integer tdv, NagError *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02bjc(Integer n, double a[], Integer tda, double b[],
                                             Integer tdb, double tol, complex alfa[],
                                             double beta[], Boolean wantv,
                                             double v[], Integer tdv, Integer iter[], NagError *fail);
  extern void f02bjw(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, Boolean matz, double z[], Integer tdz);
  extern void f02bjx(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, double eps1, Boolean matz,
                     double z[], Integer tdz, Integer iter[], Integer *info);
  //Cheney change Complex to complex 2006-6-6
  /*extern void f02bjy(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, Complex alfa[], double beta[], Boolean matz,
                     double z[], Integer tdz);
  extern void f02bjz(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, Complex alfa[], double beta[],
                     double z[], Integer tdz);*/
  extern void f02bjy(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, complex alfa[], double beta[], Boolean matz,
                     double z[], Integer tdz);
  extern void f02bjz(Integer n, double a[], Integer tda, double b[],
                     Integer tdb, complex alfa[], double beta[],
                     double z[], Integer tdz);
  extern void f02eaz_f(double amax, double rmin, double rmax, double *sigma,
                       Boolean *scale);
  extern void f02eaz(double amax, double rmin, double rmax,
                     double *sigma, Boolean *scale);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02ecc(Nag_Select_Eigenvalues crit, Integer n, double a[], Integer lda,
                                             double wl, double wu, Integer mest, Integer *m,
                                             Complex w[], Complex v[], Integer tdv, NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02ecc(Nag_Select_Eigenvalues crit, Integer n, double a[], Integer lda,
                                             double wl, double wu, Integer mest, Integer *m,
                                             complex w[], complex v[], Integer tdv, NagError *fail);
  extern void f02ecf(const char *crit, Integer n, double a[], Integer lda,
                     double wl, double wu, Integer mest, Integer *m,
                     double wr[], double wi[], double vr[],
                     Integer ldvr, double vi[], Integer ldvi,
                     double work[], Integer lwork, Integer iwork[],
                     Boolean bwork[], Integer *ifail);
  extern void f02faf_f(const char *job, const char *uplo, Integer n, double a[],
                       Integer lda, double w[], double work[], Integer lwork,
                       Integer *ifail, Integer job_len, Integer uplo_len);
  extern void f02faf(const char *job, const char *uplo, Integer n, double a[],
                     Integer lda, double w[], double work[], Integer lwork,
                     Integer *ifail);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02gcc(Nag_Select_Eigenvalues crit, Integer n, Complex a[], Integer lda,
                                             double wl, double wu, Integer mest, Integer *m,
                                             Complex w[], Complex v[], Integer ldv, NagError *fail);
  extern void f02gcf(const char *crit, Integer n, Complex a[], Integer lda,
                     double wl, double wu, Integer mest, Integer *m,
                     Complex w[], Complex v[], Integer ldv,
                     Complex work[], Integer lwork, double rwork[],
                     Integer iwork[], Boolean bwork[], Integer *ifail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02gcc(Nag_Select_Eigenvalues crit, Integer n, complex a[], Integer lda,
                                             double wl, double wu, Integer mest, Integer *m,
                                             complex w[], complex v[], Integer ldv, NagError *fail);
  extern void f02gcf(const char *crit, Integer n, complex a[], Integer lda,
                     double wl, double wu, Integer mest, Integer *m,
                     complex w[], complex v[], Integer ldv,
                     complex work[], Integer lwork, double rwork[],
                     Integer iwork[], Boolean bwork[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02swc(Integer n, double *a, Integer tda, double *d, double *e, Integer ncoly,
                     double *y, Integer tdy, Boolean wantq, double *q, Integer tdq, NagError *fail);
  extern void f02swz_f(Integer n, double a[], Integer lda, double d[],
                       double e[], Integer ncoly, double y[], Integer ldy,
                       Boolean wantq, double q[], Integer ldq, Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02sxc(Integer n, double *a, Integer tda, Integer ncoly, double *y,
                     Integer tdy, NagError *fail);
  extern void f02sxz_f(Integer n, double a[], Integer lda, Integer ncoly,
                       double y[], Integer ldy, double work[], Integer *ifail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02syc(Integer n, double *d, double *e, Integer ncolb, double *b, Integer tdb,
                     Integer nrowy, double *y, Integer tdy, Integer ncolz, double *z, Integer tdz,
                     Integer *iter, Integer *failinfo, NagError *fail);
  extern void f02syz_f(Integer n, double d[], double e[], Integer ncolb,
                       double b[], Integer ldb, Integer nrowy, double y[],
                       Integer ldy, Integer ncolz, double z[], Integer ldz,
                       double work[], Integer *ifail);
  extern void f02szc(Integer n,  double d[], double e[], double sv[],
                     Boolean wantb,  double b[],  Boolean wanty,
                     double y[],  Integer tdy, Integer ly,  Boolean wantz,
                     double z[],  Integer tdz, Integer ncz,  double work1[],
                     NagError *fail);
  extern void f02szz(Integer n, double c[], double s[], double x[]);
  //Cheney change Complex to complex 2006-6-6
 /*extern void f02uwc(Integer n, Complex *a, Integer tda, double *d, double *e,
                     Integer ncoly, Complex *y, Integer tdy, Boolean wantq, Complex *q,
                     Integer tdq, NagError *fail);
  extern void f02uxc(Integer n, Complex *a, Integer tda, Integer ncoly, Complex *y,
                     Integer tdy, NagError *fail);
  extern void f02uyc(Integer n, double *d, double *e, Integer ncolb, Complex *b, Integer tdb,
                     Integer nrowy, Complex *y, Integer tdy, Integer ncolz, Complex *z, Integer tdz,
                     Integer *iter, Integer *failinfo, NagError *fail);*/
  extern void f02uwc(Integer n, complex *a, Integer tda, double *d, double *e,
                     Integer ncoly, complex *y, Integer tdy, Boolean wantq, complex *q,
                     Integer tdq, NagError *fail);
  extern void f02uxc(Integer n, complex *a, Integer tda, Integer ncoly, complex *y,
                     Integer tdy, NagError *fail);
  extern void f02uyc(Integer n, double *d, double *e, Integer ncolb, complex *b, Integer tdb,
                     Integer nrowy, complex *y, Integer tdy, Integer ncolz, complex *z, Integer tdz,
                     Integer *iter, Integer *failinfo, NagError *fail);
  extern void f02wax(Integer m, Integer n,  double a[],  Integer tda,
                     Boolean wantb,  double b[], double sv[],
                     double work[],  Integer lwork, Integer *ifail);
  extern void f02way(Integer n,  double c[],  Integer tdc,  double pt[],
                     Integer tdpt, Integer *fail);
  extern void f02waz(Integer m, Integer n, double *a, Integer tda,
                     double *z, double *b, double *c, int *localerror);
  extern void f02wbc(Integer m, Integer n,  double a[],  Integer tda,
                     Boolean wantb,  double b[], double sv[],
                     double work[],  Integer lwork, Integer *ifail);
  extern void f02wby(Integer m, Integer n,  double a[],  Integer tda,
                     double x[], double y[], double work[], Integer *fail);
  extern void f02wbz(Integer m, Integer n,  double c[],  Integer tdc,
                     double pt[],  Integer tdpt,  double work[],  Integer *fail);
  extern void f02wcy(Integer n, double c[], Integer tdc, double q[],
                     Integer tdq,  double work1[], double work2[], Integer *fail);
  extern NAG_DLL_EXPIMP void NAG_CALL f02wdc(Integer m, Integer n,  double a[],  Integer tda,
                     Boolean wantb,  double b[], double tol,  Boolean *svd,
                     Integer *irank,  double z[], double sv[],
                     Boolean wantr,  double r[],  Integer tdr,  Boolean wantpt,
                     double pt[],  Integer tdpt,  double work[],
                     Integer lwork, NagError *fail);
  extern Integer f02wdy(Integer n, double sv[], double tol);
  extern double f02wdz_f(Integer n, const double a[], Integer nra, double work[]);
  extern double f02wdz(Integer n,double *a,Integer tda,double *work, int *localerror);
  extern NAG_DLL_EXPIMP void NAG_CALL f02wec(Integer m, Integer n, double *a, Integer tda, Integer ncolb,
                                             double *b, Integer tdb, Boolean wantq, double *q, Integer tdq, double *sv,
                                             Boolean wantp, double *pt, Integer tdpt, Integer *iter, double *e,
                                             Integer *failinfo, NagError *fail);
  extern void f02wex(Integer nx, Integer ny, double *alpha, double *x, Integer incx,
                     double *y, Integer incy, double tol, double *zeta);
  extern NAG_DLL_EXPIMP void NAG_CALL f02wuc(Integer n, double *a, Integer tda, Integer ncolb, double *b,
                     Integer tdb, Boolean wantq, double *q, Integer tdq, double *sv, Boolean wantp,
                     Integer *iter, double *e, Integer *failinfo, NagError *fail);
  extern void f02wuf_f(Integer n, double a[], Integer lda, Integer ncolb,
                       double b[], Integer ldb, Boolean wantq, double q[],
                       Integer ldq, double sv[], Boolean wantp, double work[],
                       Integer *ifail);
  //Cheney change Complex to complex 2006-6-6
  /*extern NAG_DLL_EXPIMP void NAG_CALL f02xec(Integer m, Integer n, Complex *a, Integer tda, Integer ncolb,
                                             Complex *b, Integer tdb, Boolean wantq, Complex *q, Integer tdq,
                                             double *sv, Boolean wantp, Complex *ph, Integer tdph, Integer *iter,
                                             double *e, Integer *failinfo, NagError *fail);
  extern void f02xex(Integer nx, Integer ny, Complex *alpha, Complex *x, Integer incx,
                     Complex *y, Integer incy, double tol, Complex *theta);
  extern void f02xuc(Integer n, Complex *a, Integer tda, Integer ncolb,
                     Complex *b, Integer tdb, Boolean wantq, Complex *q, Integer tdq,
                     double *sv, Boolean wantp, Integer *iter, double *e, Integer *failinfo,
                     NagError *fail);*/
  extern NAG_DLL_EXPIMP void NAG_CALL f02xec(Integer m, Integer n, complex *a, Integer tda, Integer ncolb,
                                             complex *b, Integer tdb, Boolean wantq, complex *q, Integer tdq,
                                             double *sv, Boolean wantp, complex *ph, Integer tdph, Integer *iter,
                                             double *e, Integer *failinfo, NagError *fail);
  extern void f02xex(Integer nx, Integer ny, complex *alpha, complex *x, Integer incx,
                     complex *y, Integer incy, double tol, complex *theta);
  extern void f02xuc(Integer n, complex *a, Integer tda, Integer ncolb,
                     complex *b, Integer tdb, Boolean wantq, complex *q, Integer tdq,
                     double *sv, Boolean wantp, Integer *iter, double *e, Integer *failinfo,
                     NagError *fail);
  extern void f02xus_f(Integer n, double d[], double e[], Boolean wantcs,
                       double c[], double s[]);
  extern void f02xus(Integer n, double *d, double *e, Boolean wantcs, double *c, double *s);
  extern void f02xut_f(double test, Integer n, const double d[], const double e[],
                       Boolean *force, Integer *p);
  extern void f02xut(double test, Integer n, double *d, double *e, Boolean *force, Integer *p);
  extern void f02xuu_f(Integer job, double d1, double e1, double dnm1,
                       double dn, double enm2, double enm1, double *c,
                       double *s);
  extern void f02xuu(Integer job, double d1, double e1, double dnm1, double dn,
                     double enm2, double enm1, double *c, double *s);
  extern void f02xuv_f(const char *shift, Integer m, Integer n, double d[],
                       double e[], double *c, double *s, Boolean wantlt,
                       double cl[], double sl[], Boolean wantrt, double cr[],
                       double sr[], Integer shift_len);
  extern void f02xuv(Nag_InitRotation shift, Integer m, Integer n, double *d, double *e,
                     double c, double s, Boolean wantlt, double *cl, double *sl, Boolean wantrt,
                     double *cr, double *sr);
  extern void f02xuw_f(Integer m, Integer n, double d[], double e[],
                       Boolean wantcs, double c[], double s[]);
  extern void f02xuw(Integer m, Integer n, double *d, double *e, Boolean wantcs,
                     double *c, double *s);
  /* end proto */
#ifdef __cplusplus
}
#endif
#endif /* not NAGF02 */
